/* ***************************************************** **
   ch12_answering_top_n_questions.sql
   
   Skrypt dla książki Praktyczna nauka SQL dla Oracle, Helion (2022),
   napisanej przez Kima Berga Hansena, https://www.kibeha.dk
   Używasz na własną odpowiedzialność.
   *****************************************************
   
   Rozdział 12.
   Udzielanie odpowiedzi na pytania typu Najlepsze-N
   
   Skrypt przeznaczony do wykonania w schemacie PRACTICAL
** ***************************************************** */

/* -----------------------------------------------------
   Konfiguracja formatowania sqlcl
   ----------------------------------------------------- */

set pagesize 80
set linesize 80
set sqlformat ansiconsole

/* -----------------------------------------------------
   Przykładowy kod do rozdziału 12.
   ----------------------------------------------------- */

-- Listing 12.2. Widok danych dotyczących sprzedaży całkowitej

select product_name, total_qty
from total_sales
order by total_qty desc;

-- W ten sam sposób można pobrać dane z widoku yearly_sales

select yr, product_name, yr_qty
from yearly_sales
order by yr, yr_qty desc;

-- Listing 12.3. Widok zawierający dane o rocznej sprzedaży
-- (zostały sformatowane ręcznie, bez użycia ansiconsole)

set pagesize 60
set linesize 60
set sqlformat
column rn format 99
column 2016_prod format a9
column 2016 format 999
column 2017_prod format a9
column 2017 format 999
column 2018_prod format a9
column 2018 format 999

select *
from (
   select
      yr, product_name, yr_qty
    , row_number() over (
         partition by yr
         order by yr_qty desc
      ) as rn
   from yearly_sales
)
pivot (
   max(product_name) as prod
 , max(yr_qty)
   for yr in (
      2016, 2017, 2018
   )
)
order by rn;

set pagesize 60
set linesize 60
set sqlformat ansiconsole

-- Listing 12.4. Zapytanie typu Najlepsze-N wykonywane z użyciem widoku osadzonego i filtrowania według pseudokolumny rownum

select *
from (
   select product_name, total_qty
   from total_sales
   order by total_qty desc
)
where rownum <= 3;

-- Listing 12.5. Zapytanie typu Najlepsze-3 wykonywane za pomocą widoku osadzonego i filtrowania według wyniku wywołania row_number()

select *
from (
   select
      product_name, total_qty
    , row_number() over (order by total_qty desc) as ranking
   from total_sales
)
where ranking <= 3
order by ranking;

-- Listing 12.6. Porównanie trzech funkcji analitycznych przeznaczonych do tworzenia rankingów

select
   product_name, total_qty
 , row_number() over (order by total_qty desc) as rn
 , rank() over (order by total_qty desc) as rnk
 , dense_rank() over (order by total_qty desc) as dr
from total_sales
order by total_qty desc;

-- Zmiana funkcji rankingu listingu 12.5 na rank()

select *
from (
   select
      product_name, total_qty
    , rank() over (order by total_qty desc) as ranking
   from total_sales
)
where ranking <= 3
order by ranking;

-- Zmiana funkcji rankingu listingu 12.5 na dense_rank()

select *
from (
   select
      product_name, total_qty
    , dense_rank() over (order by total_qty desc) as ranking
   from total_sales
)
where ranking <= 3
order by ranking;

-- Listing 12.7. Pobieranie jedynie trzech pierwszych rekordów

select product_name, total_qty
from total_sales
order by total_qty desc
fetch first 3 rows only;

-- Pobranie tylko trzech pierwszych rekordów

select product_name, total_qty
from total_sales
order by total_qty desc
fetch first 3 rows with ties;

-- Listing 12.8. Porównanie funkcji analitycznych przeprowadzających analizę danych o sprzedaży za 2018 rok

select
   product_name, yr_qty
 , row_number() over (order by yr_qty desc) as rn
 , rank() over (order by yr_qty desc) as rnk
 , dense_rank() over (order by yr_qty desc) as dr
from yearly_sales
where yr = 2018
order by yr_qty desc
fetch first 5 rows only;

-- Listing 12.9. Zapytanie pobierające trzy pierwsze rekordy danych o sprzedaży za 2018 rok

select product_name, yr_qty
from yearly_sales
where yr = 2018
order by yr_qty desc
fetch first 3 rows only;

-- Deterministyczne dane wyjściowe

select product_name, yr_qty
from yearly_sales
where yr = 2018
order by yr_qty desc, product_id
fetch first 3 rows only;

-- Pobieranie z użyciem with ties

select product_name, yr_qty
from yearly_sales
where yr = 2018
order by yr_qty desc
fetch first 3 rows with ties;

-- Inna kolejność i opcja with ties nie mają sensu

select product_name, yr_qty
from yearly_sales
where yr = 2018
order by yr_qty desc, product_id
fetch first 3 rows with ties;

-- Porównanie w 2017 roku (kopia listingu 12.8)

select
   product_name, yr_qty
 , row_number() over (order by yr_qty desc) as rn
 , rank() over (order by yr_qty desc) as rnk
 , dense_rank() over (order by yr_qty desc) as dr
from yearly_sales
where yr = 2017
order by yr_qty desc
fetch first 5 rows only;

-- Listing 12.10. Pobieranie za pomocą with ties danych o sprzedaży dotyczących 2017 roku

select product_name, yr_qty
from yearly_sales
where yr = 2017
order by yr_qty desc
fetch first 3 rows with ties;

-- Listing 12.11. Przykład użycia funkcji dense_rank() do wykonania zadania niemożliwego dla reguły pierwszych rekordów

select *
from (
   select
      product_name, yr_qty
    , dense_rank() over (order by yr_qty desc) as ranking
   from yearly_sales
   where yr = 2017
)
where ranking <= 3
order by ranking;

-- Listing 12.12. Ranking dla poszczególnych lat wygenerowany za pomocą funkcji row_number()

select *
from (
   select
      yr, product_name, yr_qty
    , row_number() over (
         partition by yr
         order by yr_qty desc
      ) as ranking
   from yearly_sales
)
where ranking <= 3
order by yr, ranking;

-- Zmiana funkcji rankingu na rank()

select *
from (
   select
      yr, product_name, yr_qty
    , rank() over (
         partition by yr
         order by yr_qty desc
      ) as ranking
   from yearly_sales
)
where ranking <= 3
order by yr, ranking;

-- Zmiana funkcji rankingu na dense_rank()

select *
from (
   select
      yr, product_name, yr_qty
    , dense_rank() over (
         partition by yr
         order by yr_qty desc
      ) as ranking
   from yearly_sales
)
where ranking <= 3
order by yr, ranking;

-- Listing 12.13. Przykład użycia klauzuli fetch first w widoku osadzonym stosującym złączenie lateral 

select top_sales.*
from (
   select 2016 as yr from dual union all
   select 2017 as yr from dual union all
   select 2018 as yr from dual
) years
cross join lateral (
   select yr, product_name, yr_qty
   from yearly_sales
   where yearly_sales.yr = years.yr
   order by yr_qty desc
   fetch first 3 rows with ties
) top_sales;

/* ***************************************************** */
